/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.jei.ui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.addons.jei.ui.CropDisplayInfo;
import net.darkhax.botanypots.data.recipes.crop.BasicCrop;
import net.darkhax.botanypots.data.recipes.crop.HarvestEntry;
import net.darkhax.botanypots.data.recipes.soil.BasicSoil;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_124;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class BasicCropDisplayInfo
extends CropDisplayInfo {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private final class_2960 id;
    private final List<class_1856> seeds;
    private final List<class_1856> soils;
    private final List<HarvestEntry> drops;
    private final int growthTime;
    private final float modifier;

    public static List<CropDisplayInfo> getCropRecipes(BasicCrop crop, List<Soil> soils) {
        ArrayList<CropDisplayInfo> info = new ArrayList<CropDisplayInfo>();
        for (Soil soil : soils) {
            if (!(soil instanceof BasicSoil)) continue;
            BasicSoil basicSoil = (BasicSoil)soil;
            if (!crop.canGrowInSoil(null, null, null, soil)) continue;
            int ticks = BotanyPotHelper.getRequiredGrowthTicks(null, null, null, crop, soil);
            info.add(new BasicCropDisplayInfo(crop.method_8114(), crop.getSeed(), basicSoil.getIngredient(), crop.getResults(), ticks, basicSoil.getGrowthModifier()));
        }
        return info;
    }

    public BasicCropDisplayInfo(class_2960 id, class_1856 seeds, class_1856 soils, List<HarvestEntry> drops, int growthTime, float modifier) {
        this(id, List.of(seeds), List.of(soils), drops, growthTime, modifier);
    }

    public BasicCropDisplayInfo(class_2960 id, List<class_1856> seeds, List<class_1856> soils, List<HarvestEntry> drops, int growthTime, float modifier) {
        this.id = id;
        this.seeds = seeds;
        this.soils = soils;
        this.drops = drops;
        this.growthTime = growthTime;
        this.modifier = modifier;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
        IRecipeSlotBuilder seedSlot = builder.addSlot(RecipeIngredientRole.INPUT, 31, 11);
        this.seeds.forEach(arg_0 -> ((IRecipeSlotBuilder)seedSlot).addIngredients(arg_0));
        seedSlot.addTooltipCallback(this.getSeedTooltip());
        IRecipeSlotBuilder soilSlot = builder.addSlot(RecipeIngredientRole.INPUT, 31, 29);
        this.soils.forEach(arg_0 -> ((IRecipeSlotBuilder)soilSlot).addIngredients(arg_0));
        soilSlot.addTooltipCallback(this.getSoilTooltip());
        int dropCount = 0;
        for (HarvestEntry entry : this.drops) {
            IRecipeSlotBuilder dropSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 81 + 18 * (dropCount % 4), 1 + 18 * (dropCount / 4));
            dropSlot.addItemStack(entry.getItem());
            dropSlot.addTooltipCallback(this.getDropTooltip(entry));
            ++dropCount;
        }
    }

    private IRecipeSlotTooltipCallback getSeedTooltip() {
        return (view, tooltip) -> tooltip.add(class_2561.method_43469((String)"tooltip.botanypots.grow_time", (Object[])new Object[]{BasicCropDisplayInfo.ticksToTime(this.growthTime)}).method_27692(class_124.field_1080));
    }

    private IRecipeSlotTooltipCallback getSoilTooltip() {
        return (view, tooltip) -> tooltip.add(class_2561.method_43469((String)"tooltip.botanypots.modifier", (Object[])new Object[]{FORMAT.format(this.modifier)}).method_27692(class_124.field_1080));
    }

    private IRecipeSlotTooltipCallback getDropTooltip(HarvestEntry drops) {
        return (view, tooltip) -> {
            tooltip.add(class_2561.method_43469((String)"tooltip.botanypots.chance", (Object[])new Object[]{FORMAT.format(drops.getChance() * 100.0f)}).method_27692(class_124.field_1080));
            int rollMin = drops.getMinRolls();
            int rollMax = drops.getMaxRolls();
            if (rollMin == rollMax) {
                tooltip.add(class_2561.method_43469((String)"tooltip.botanypots.rolls", (Object[])new Object[]{rollMin}).method_27692(class_124.field_1080));
            } else {
                tooltip.add(class_2561.method_43469((String)"tooltip.botanypots.rollrange", (Object[])new Object[]{rollMin, rollMax}).method_27692(class_124.field_1080));
            }
        };
    }

    @Override
    public void draw(IRecipeSlotsView view, class_4587 stack, double mouseX, double mouseY, IGuiHelper guiHelper) {
        IDrawableStatic slot = guiHelper.getSlotDrawable();
        slot.draw(stack, 30, 10);
        slot.draw(stack, 30, 28);
        for (int nextSlotId = 0; nextSlotId < 12; ++nextSlotId) {
            slot.draw(stack, 80 + 18 * (nextSlotId % 4), 18 * (nextSlotId / 4));
        }
    }

    @Override
    public class_2960 getCropId() {
        return this.id;
    }

    private static String ticksToTime(int ticks) {
        ticks = Math.abs(ticks);
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }
}

